var get_board_type_xhr = new XMLHttpRequest();
var button_command_xhr = new XMLHttpRequest();
var get_one_wire_xhr = new XMLHttpRequest();
var selected_accordion = 0;
var boards_count = 9;
var one_wire_count = 16;

function form_tag_tr(param_name, eds_index, eds_subindex)
{
    return form_tag_tr_param({name: param_name, index: eds_index, sub: eds_subindex})
}

function form_tag_tr_param(param)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param.name))//.addClass("name"));
	var div = $('<div>').addClass("tag").attr({"index": `${param.index.toString(16).toUpperCase()}:${param.sub}`});
    tr.append($('<td>').append(div))//.addClass("name"));
    return tr;
}

function form_tag_tr2(param_name, eds_index, eds_subindex, param_name2, eds_index2, eds_subindex2)
{
	return form_tag_tr2_param({name: param_name, index: eds_index, sub: eds_subindex, type: ""},
							{name: param_name2, index: eds_index2, sub: eds_subindex2, type: ""})
}

function form_tag_tr2_param(param1, param2)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param1.name))//.addClass("name"));
	var div = $('<div>').addClass("tag").attr({"index": `${param1.index.toString(16).toUpperCase()}:${param1.sub}`});
	if ("type" in param1) 
	{
		div.addClass(param1.type)
	}
    tr.append($('<td>').append(div))//.addClass("name"));
	//tr.append($('<td>'))//.addClass('empty_space'));
	if (param2.name != "")
	{
		tr.append($('<td>').text(param2.name).addClass("name"));
	}
    
	var div2 = $('<div>').addClass("tag").attr({"index": `${param2.index.toString(16).toUpperCase()}:${param2.sub}`});
	if ("type" in param2) 
	{
		div2.addClass(param2.type)
	}
    tr.append($('<td>').append(div2))//.addClass("name"));
    return tr;
}

function form_name_tr(param_name)
{
    return $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name")).append($('<td>'));
}

function form_tag_divide_tr(param_name, eds_index_num, eds_subindex_num, eds_index_den, eds_subindex_den)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name"));
    var table = $('<table>');
    var div1 = $('<div>').addClass("io").addClass("tag").attr({"index": `${eds_index_num.toString(16).toUpperCase()}:${eds_subindex_num}`});
    var div2 = $('<div>').addClass("io").addClass("tag").attr({"index": `${eds_index_den.toString(16).toUpperCase()}:${eds_subindex_den}`});
    table.append($('<tr>').append(($('<td style="border-bottom-color: black">').append(div1))))
    table.append($('<tr>').append(($('<td>').append(div2))))
    tr.append($('<td>').append(table));
    return tr;
}

function form_multy_tag_tr(param_name, eds_index, count, start_index=1)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name"));
    for (var eds_subindex = start_index; eds_subindex < start_index+count; eds_subindex++)
    {
        var div = $('<div>').addClass("io").addClass("tag").attr({"index": `${eds_index.toString(16).toUpperCase()}:${eds_subindex}`});
        tr.append($('<td>').append(div));
    }
    return tr;
}

function form_multy_header(param_name, count)
{
    var tr = $('<tr class="table_header">').append($('<td>').text(param_name).addClass("name"));
    for (var eds_subindex = 1; eds_subindex < count+1; eds_subindex++)
    {
        var div = $('<div>').text(eds_subindex);
        tr.append($('<td>').append(div));
    }
    return tr;
}

function create_block(table_inner, data)
{
    $.each(data.blocks, function(block_index, block_item)
    {
		var hr = $('<tr class="table_header">').append($('<td  colspan="2">').text(block_item.header).addClass("name"));
		
		table_inner.append(hr);
        $.each(block_item.params, function(param_index, param_item)
        {
            if (param_item.index != null && param_item.sub != null)
            {
                table_inner.append(form_tag_tr_param(param_item));
            }
            else
            {
                table_inner.append(form_name_tr(param_item.name));
            }
        })
    })
}

$(document).ready(function()
{
	get_set_value.show_main_view_intreface()
	var query = '/get_od_data.form?';
	query += `0x2000_2`; //product code
	// Request bords types 
    var start_number = 1;
    for (var board_number = start_number; board_number <= boards_count; board_number++)
    {
        /*if (board_number >= start_number) { query += "&"; }*/
        query += `&0x1027_${(board_number)}`; //board type
	}	
    get_board_type_xhr.open('GET', query, true);
	get_board_type_xhr.send();	
});

function show_boards_by_type(types)
{

}

$(document).on('click', '#COMMAND_CLEAR_MTHRS', function()
{
	result = confirm(l100n.localize_string("COMMAND_CLEAR_MTHRS_confirm_question"));
	if (result == true)
	{
		var board_number = $(this).attr("board_number");
		var query = `/set_od_data.form?0x4${board_number-1}03_1=0x73726872`;
		button_command_xhr.open('GET', query, true);
		button_command_xhr.send();
	}
});

$(document).on('click', '#COMMAND_CLEAR_ENERGY', function()
{
	result = confirm(l100n.localize_string("COMMAND_CLEAR_ENERGY_confirm_question"));
	if (result == true)
	{
		var board_number = $(this).attr("board_number");
		var query = `/set_od_data.form?0x4${board_number-1}03_1=0x746e6372`;
		button_command_xhr.open('GET', query, true);
		button_command_xhr.send();
	}
});

function show_one_wire(sensorsId)
{
	if (!$.isEmptyObject(sensorsId))
	{
		var h3 = $(`<h3>`).text(l100n.localize_string("ext_Channels_header"))
		var commands = [{"name": l100n.localize_string("not selected"), "command": "0x0"}]
		sensorsId.forEach(function(id, i) {
			commands.push({"name": id, "command": id})
		});

		var sensors_table = $('<table>');
		var table_head = $('<tr>').addClass('table_header')
		table_head.append($('<td colspan="1">').text(""))
	    table_head.append($('<td colspan="1">').text(l100n.localize_string("ext_Settings")))
		table_head.append($('<td colspan="1">').text(l100n.localize_string("AI Read Float")))
		sensors_table.append(table_head)
		
		var start_number = 1;
		var end_number = one_wire_count;
		for (var sensor_number = start_number; sensor_number <= end_number; sensor_number++)
		{
			configuration.add_template({"index": `4C08_${sensor_number}`,"template": "combobox", "commands": commands})
			var tr = $('<tr class="can_hide">').append($('<td>').text(`${l100n.localize_string("ext_Channel")} ${sensor_number} `))
			tr.append($('<td>').append($('<div class="sensor_select">').addClass("tag").attr({"index": `4C08:${sensor_number}`})))
			tr.append($('<td>').append($('<div>').addClass("tag").attr({"index": `4C31:${sensor_number}`})))
			sensors_table.append(tr)
		}

		//var sensors_div = $('<div>').addClass("board")		
		var sensors_head = $('<div>').text(l100n.localize_string("1 Wire accordion header")).addClass("accordion-header")
		var sensors_body = $('<div>').append(sensors_table).addClass("accordion-body")
		$("#boyan").append(h3).append(sensors_head).append(sensors_body)
		//$("#io_settings").append(sensors_div)

	}
	//console.log(configuration.data_type_template().templates)
}

function response_one_wire()
{
	// Request 1-Wire sensors
	var query2 = '/get_od_data.form?';
	var start_number = 1;
	var end_number = one_wire_count;
	for (var sensor_number = start_number; sensor_number <= end_number; sensor_number++)
	{
		if (sensor_number > start_number) { query2 += "&"; }
		query2 += `0x4C0A_${sensor_number}`; //sensor ID
	}
	get_one_wire_xhr.open('GET', query2, true);
	get_one_wire_xhr.send();
} 

function response_ready()
{
	var values = get_set_value.get_response_values(get_board_type_xhr)
	var product_code = values[0]
	var types = values.slice(1)	
	
	var product_code_arr = get_set_value.ip2array(product_code)
	//console.log(product_code_arr)
	if (product_code_arr[0] == 11) //EM-12
	{
		var board_index = "0x3F01"
		var board_status = $('<div>').addClass('tag').addClass('board_status').attr({"index": `${board_index}:1`}).hide()
		var board_body = $('<div>').addClass("accordion-body").append(board_status);
		var board_div = $('<div>').addClass("board").attr({"id": `board_0`}).append(board_body);
		$("#board_head").append(board_div);
	}

	mcu_common.show_boards_by_type(types)
	//user.parse_page()
	

	response_one_wire()
}

function response_one_wire_ready()
{
	var values = get_set_value.get_response_values(get_one_wire_xhr)
	//console.log(values)
	let sensors_ID = values.filter(element => element !== "0x0");
	//console.log(sensors_ID)
	show_one_wire(sensors_ID)

	$("#boyan").accordion({ heightStyle: 'content', header: '.accordion-header', active: 0});
	$("#boyan").accordion( "option", "collapsible", true );
	user.parse_page()
	$('.can_hide').each(function( index )
	{
		var form = $(this).children('.value_td').children('.tag').children('.apply_form')
		if ($(form).hasClass('empty')) { $(this).hide() }
	});
	$("div[index='1001:0']").hide()
	$(".tab-class").tabs();
}

$(document).on('click', '.accordion-header', function()
{
    selected_accordion = $(this).index();
});

$(document).on('value_loaded', 'div[tb_index="1001_0"]', function( e )
{
    var device_error = $(this).text()
    if (device_error > 0)
    {
        $('.device_status').addClass('device_error')
    }
    else
    {
        $('.device_status').removeClass('device_error')
    }

    $(this).removeClass('value_loaded')
});

$(document).on('value_loaded', '.board_status', function( e )
{
    var board = $(this).children('form').children('div.value')
    var board_error = board.text()
    var status_index = $(this).attr('index')
    if (board_error > 0)
    {
        $(`div[status_index="${status_index}"]`).addClass('device_error')
    }
    else
    {
        $(`div[status_index="${status_index}"]`).removeClass('device_error')
    }

    //$(this).removeClass('board_error')
    $(this).removeClass('value_loaded')
});

get_board_type_xhr.onreadystatechange = function()
{
    //console.log(get_board_type_xhr.readyState);
    if (get_board_type_xhr.readyState == 4)
    {
        if (get_board_type_xhr.status == 200)
        {
            response_ready();
        }
        else
        {
            alert("Проверьте соединение с контроллером...");
        }
    }
}

get_one_wire_xhr.onreadystatechange = function()
{
    //console.log(get_one_wire_xhr.readyState);
    if (get_one_wire_xhr.readyState == 4)
    {
        if (get_one_wire_xhr.status == 200)
        {
            response_one_wire_ready();
        }
        else
        {
            alert("Проверьте соединение с контроллером...");
        }
    }
}
